<?php
/**
 * Program Controller
 * @author Andy Aliansah <andyaliansah97@gmail.com>
 */
use libraries\BaseController;

class Programs extends BaseController
{
	/**
	 * Constructor CodeIgniter
	 */
	public function __construct()
	{
		parent::__construct();
		$this->auth->check_auth();

		// load model
		$this->load->model('Programs_model');
		$this->load->model('Requirements_model');
	}

	/**
	 * Halaman Index
	 *
	 * @return HTML
	 */

	public function index()
 	{	
		$data['content_title'] = 'Program';
		
		$this->twiggy_display('adm/programs/index', $data);
	}
	 
	public function get_data_header()
	{	
		$data = [];
		$get_data = $this->Programs_model->program_header()->result();

		// ketika data tersedia
		// maka generate data json untuk Datatable
		if($get_data)
		{
			$no = 1;
			foreach($get_data as $get_row)
			{	
				$program_accreditation_name = ($get_row->program_accreditation_id == null ? "" : $get_row->program_accreditation_name);
				$data[] = array(
					'no'    => $no,
					'id'    => $get_row->program_header_id,
					'class' => $get_row->program_class_name,
					'type'  => $get_row->program_type_name,
					'name'  => $get_row->program_header_name,
					'accreditation'  => $program_accreditation_name,
					'certificate_release'  => $get_row->program_header_certificate_release,
					// 'meeting_type'  => $get_row->program_header_meeting_tipe,
				);
				$no++;
			}
		}

		$response = [
            'data'         => $data,
            'recordsTotal' => count($data)
        ];

        output_json($response);
	}

 	public function edit($id = 'new')
	{
		$title = "Tambah Program";
		$header_data = array(null);

	    if($id != 'new')
	    {
			$title       = "Edit Program";
			$header_data = $this->Programs_model->program_header($id)->row_array();
		}
		
		$certificate_release = [
			[
				'c_id'   => 'Sertifikat',
				'c_name' => 'Sertifikat'
			],
			[
				'c_id'   => 'Tanpa Sertifikat',
				'c_name' => 'Tanpa Sertifikat'
			],
		];

		$data['id']            = $id;
		$data['content_title'] = $title;
		$data['header_data']   = $header_data;
		$data['class_data']    = $this->Programs_model->get_data_class()->result();
		$data['type_data']     = $this->Programs_model->get_data_type()->result();
		$data['acc_data']      = $this->Programs_model->get_data_accreditation()->result();
		$data['certificate_release']  = $certificate_release;

		// echo json_encode($class);
		// die();

		$this->twiggy_display('adm/programs/edit', $data);
	}

	public function get_data_detail()
	{	
		$id = $this->input->post("id");

		$data = [];
		$get_data = $this->Programs_model->program_detail($id)->result();

		// ketika data tersedia
		// maka generate data json untuk Datatable
		if($get_data)
		{
			$no = 1;
			foreach($get_data as $get_row)
			{

				$data[] = array(
					'no'   => $no,
					'id'   => $get_row->requirement_id,
					'code' => $get_row->requirement_code,
					'name' => $get_row->requirement_name
				);
				$no++;
			}
		}

		output_json($data);
	}

	public function get_embed()
	{
		$data = [];
		$data['content_title'] = 'Data Persyaratan';
		$this->twiggy_display('adm/programs/embed', $data);
	}

	public function get_data_embed()
	{
		$data = [];
		$response = [];
		$search   = $this->input->post('search');

		$get_data  = $this->Requirements_model->get_data_advance($search)->result();
		// $get_data_active = $this->Programs_model->program_detail(15, false)->result();
		
		// $a = [];
		// foreach($get_data_active as $get_row)
		// {	
		// 	$a[] = $get_row->requirement_id;
		// }

		$no = 0;
		
		foreach($get_data as $get_row)
		{	

			// $background_color = '';
			// if(in_array($get_row->requirement_id, $a)){
			// 	$background_color = 'bg-success';
			// }

			$data[] = array(
					'no'   => $no,
					'id'   => $get_row->requirement_id,
					'code' => $get_row->requirement_code,
					'name' => $get_row->requirement_name,
					'desc' => $get_row->requirement_description,
					// 'background' => $background_color,
					'btncolor' => '',
					'btnicon'  => '',
			);

			$no++;
		}

		$response = [
            'data'         => $data,
            'recordsTotal' => count($data)
        ];

		output_json($response);
		
	}

	public function save()
	{	
		$id    = $this->input->post('id');
		$name  = $this->input->post("name");
		$class = $this->input->post("class");
		$type  = $this->input->post("type");
		$accreditation  = $this->input->post("accreditation");
		$certificate_release   = $this->input->post("certificate_release");
		// $meeting_type   = $this->input->post("meeting_type");
		
		$vuedata = $this->input->post('vuedata');
		$header_id   = $id;
		
		$header_data = [
			'program_header_class_id'            => $class,
			'program_header_type_id'             => $type,
			'program_header_accreditation_id'    => $accreditation,
			'program_header_name'                => $name,
			'program_header_certificate_release' => $certificate_release,
			// 'program_header_meeting_tipe'     => $meeting_type,
		];

		$detail_data = [];

		// if save $id = new else update data
		if($id == "new")
		{
			// save header
			$save_header = $this->Programs_model->save_header($header_data);
			if($save_header)
			{
				$header_id = $this->db->insert_id();
				foreach($vuedata as $row)
				{
					$detail_data[] = [
						'program_detail_header_id'      => $header_id,
						'program_detail_requirement_id' => $row['id']
					];
				}
				
				$save_detail = $this->Programs_model->save_detail($detail_data, true);
				
				if($save_detail)
				{
					$msg    = "Berhasil menyimpan data";
					$status = "success";
				}
				else
				{
					$msg    = "Gagal menyimpan data";
					$status = "error";	
				}
			}
			else
			{
				$msg    = "Gagal menyimpan data";
				$status = "error";	
			}
			
		}else{
				
			$delete_detail = $this->Programs_model->delete_detail($id);

			if ($delete_detail) {
				$save_header = $this->Programs_model->update_header($id, $header_data);

				if($save_header)
				{
					// $header_id = $this->db->insert_id();
					foreach($vuedata as $row)
					{
						$detail_data[] = [
							'program_detail_header_id'      => $header_id,
							'program_detail_requirement_id' => $row['id']
						];
					}

					$save_detail = $this->Programs_model->save_detail($detail_data, true);
					
					if($save_detail)
					{
						$msg    = "Berhasil menyimpan data";
						$status = "success";
					}
					else
					{
						$msg    = "Gagal menyimpan data";
						$status = "error";	
					}
				}else{
					$msg    = "Gagal menyimpan data";
					$status = "error";
				}

			}else{
				$msg    = "Gagal menyimpan data";
				$status = "error";
			}
		}

		$response = [
			'message' => $msg,
			'status'  => $status,
			'id'      => $header_id
		];
		output_json($response);

	}

	public function delete()
	{
		$id = $this->input->post('id');
		
		foreach($id as $row)
		{	
			$delete_header = $this->Programs_model->delete_header($row);
			
			if($delete_header){
				$delete_type = $this->Programs_model->delete_detail($row);
			}
		}

		$response = array(
			'message' => 'Berhasil menghapus data',
			'status'  => 'success'
		);

		output_json($response);
	}

}

?>
